package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.enums.DocumentTypeEnum;
import com.beiming.odr.referee.enums.MediationSuccessEnum;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Description: 保存协议书请求参数实体
 * @Author: caiwei
 * @Date: Created 2018-07-01
 */
@Data
public class SaveProtocolBookReqDTO implements Serializable {

  private static final long serialVersionUID = -779140827827576519L;

  // 协议书id
  private Long protocolId;
  
  // MeetingId
  private Long meetingId;

  // 案件id
  private Long caseId;

  // 文书类型
  private DocumentTypeEnum documentType;

  // 案件号
  private String caseNo;

  // 协议相关人员
  private List<CaseProtocolPersonnelReqDTO> personnelList;

  // 争议事项或调解过程
  private String content;

  // 达成协议或者无争议事实
  private String extendJson;

  // 创建者
  private String createUser;

  //当前token的userId
  private Long currentUserId;

  // 更新者
  private String updateUser;

  //原告意见
  private String applicantView;
  //被告意见
  private String respondentView;

  //终结调解原因
  private String finalMediationReason;

  // 备注
  private String remark;

  private MediationSuccessEnum reasonType;

  // 调解失败涉及人数。0代表5人以下，5人以上为具体人数
  private Integer failurePersonNum;

  // 文书名称
  private String docName;

  // 自定义文书模板id
  private Long customDocMldId;
}
