package com.beiming.odr.referee.dto.responsedto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 纠纷专题分析--统计结果
 * @Date: Created 2018-11-12 9:31
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DisputesSubjectStatisticsResDTO implements Serializable {


  private static final long serialVersionUID = 7979187725037898782L;

  /**
   * 调解案件走势分析
   */
  private List<DateAreaCountResDTO> dateAreaCountList;

  /**
   * 街道调解案件数量分析
   */
  private List<StatisticsAreaCaseCountResDTO> areaCaseCountList;

  /**
   * 申请人角色分析
   */
  private List<StatisticsApplicantRoleResDTO> statisticsApplicantRoleList;

  /**
   * 调解状态分析(与街道调解案件数量分析返回类相同)
   */
  private StatisticsAreaCaseCountResDTO statisticsAreaCaseCount;

  /**
   * 调解结果分析
   */
  private MediateResultStatisticsResDTO mediateResultStatistics;


}
