package com.beiming.odr.referee.dto.responsedto;


import com.beiming.odr.referee.dto.ApplicantDTO;
import com.beiming.odr.referee.dto.RespondentDTO;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 司法确认案件列表
 *
 * @author xiaoying
 * @date 2022/03/02
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class JudicialListResDTO implements Serializable {

  private static final long serialVersionUID = -2326143176608490189L;

  /**
   * law_case_check表主键
   */
  private Long lawCaseCheckId;

  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 纠纷编号
   */
  private String caseNo;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 案由
   */
  private String disputeCode;

  /**
   * 案件申请人
   */
  private ApplicantDTO applicantList;

  /**
   * 被申请人
   */
  private RespondentDTO respondentList;

  /**
   * 申请时间-提交申请的时间
   */
  private String submitTime;

  /**
   * 调解机构名称
   */
  private String orgName;

  /**
   * 审核员名称
   */
  private String checkUserName;

  /**
   * 案件进度
   */
  private String progress;

}
