package com.beiming.odr.referee.dto.responsedto.haoda;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 获得昊达司法确认结果响应DTO
 * @author xiaoying
 * @date 2021/12/07
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class HaoDaFeedBackResDTO implements Serializable {

  private static final long serialVersionUID = -3209068441805383190L;

  /**
   * 分级码
   */
  private String levelCode;

  /**
   * 申请id（莞邑调解平台）
   */
  private String applyId;

  /**
   * 受理结果
   * 1 代表成功 0 代表失败
   */
  private String result;

  /**
   * 受理结果说明
   */
  private String resultRemark;

  /**
   * 当事人申请文书材料信息
   */
  private List<ApplyDocumentDTO> applyDocumentDTOList;

}