package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.FinancialCountDTO;
import com.beiming.odr.referee.dto.requestdto.FinancialQueryRequestDTO;
import com.beiming.odr.referee.dto.requestdto.extra.ExtrOperationCaseReqDTO;
import com.beiming.odr.referee.dto.requestdto.financial.GetSettlementReqDTO;
import com.beiming.odr.referee.dto.responsedto.CaseMaterialListResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseFinancialDTO;
import java.util.List;

/**
 * @author zhouxin
 * @since 2019/8/6
 */
public interface LawCaseFinancialApi {

  List<LawCaseFinancialDTO> getLawCaseFinancialByPage(
      FinancialQueryRequestDTO financialQueryRequestDTO);

  Integer updateExamineResult(List<Long> lawCaseIds, Integer result, String userName);

  LawCaseFinancialDTO selectByLawCaseId(Long lawCaseId);

  List<FinancialCountDTO> countGroupByResult();

  Integer countLawCaseFinancialByPage(FinancialQueryRequestDTO financialQueryRequestDTO);

  List<Long> selectPersonByNameOrPhone(String search);

  Integer insert(LawCaseFinancialDTO lawCaseFinancialDTO);

  Integer operationCase(ExtrOperationCaseReqDTO req);

  DubboResult<CaseMaterialListResDTO> getSettlement(GetSettlementReqDTO req);
}
