package com.beiming.odr.referee.api.haoda;

import com.beiming.odr.referee.dto.requestdto.haoda.CheckResultDTO;
import com.beiming.odr.referee.dto.requestdto.haoda.JudicialConfirmHistoryDTO;
import com.beiming.odr.referee.dto.requestdto.haoda.JudicialConfirmResultDTO;

/**
 * 昊达数据推送接口
 * @author xiaoying
 * @date 2021/11/25
 */
public interface HaoDaPushApi {

  /**
   * 昊达返回司法确认或网上立案结果
   * @param dto
   * @return
   */
  void judicialConfirmResult(JudicialConfirmResultDTO dto);

  /**
   * 昊达 返回司法确认或网上立案审核结果
   * @param dto
   */
  void checkResult(CheckResultDTO dto);

  /**
   * 根据案件id查询历史记录
   * @param historyDTO
   * @return
   */
  JudicialConfirmHistoryDTO findHistoryByCaseId(JudicialConfirmHistoryDTO historyDTO);
}