package com.beiming.odr.referee.api.report;

import com.alibaba.fastjson.JSONObject;
import com.beiming.odr.referee.dto.responsedto.CloseCaseTopTenResDTO;
import com.beiming.odr.referee.dto.responsedto.LawCaseAnalyseResDTO;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author 46915
 * @date 2023/02/15
 * @describes
 */
public interface RiskAssessServiceApi {

  JSONObject priRiskAnalysis(String startDate, String endDate, String disputeType, String area);

  JSONObject synthesisAnalysis(String startDate, String endDate, String areaCode);

  JSONObject disputeTypeTrendAnalysis(String startDate, String endDate, String disputeType, String countTag, String areaCode);

  JSONObject groupCaseAnalysis(String startDate, String endDate, String disputeType, String areaCode);

  JSONObject getMediationInstitutionTime(String startDate, String endDate, String areaCode);

  JSONObject getResources(String startDate, String endDate);

  PageInfo dealCaseTimeWithInstitution(String startDate, String endDate, Integer pageSize, Integer pageNum, String areaCode);

  PageInfo analyseCaseNumByMonth(String startDate, String endDate, Integer pageSize, Integer pageNum, String areaCode);

  JSONObject countCaseNumByDisputeType(String startDate, String endDate, String areaCode);

  PageInfo dealCaseNumWithInstitution(String startDate, String endDate, Integer pageSize, Integer pageNum, String areaCode);

  JSONObject analyseCaseNumByArea(String startDate, String endDate, String areaCode);

  JSONObject peopleMediationCasesReport(String startDate, String endDate, String disputeType, String surveyResults, String organization);

  JSONObject oneStepStatistics(String startDate, String endDate);

  JSONObject caseApplicantTypeAndImage(String startDate, String endDate, String disputeType);

  JSONObject countDeferredCase(String startDate, String endDate);

  ArrayList<LawCaseAnalyseResDTO> countSubsidyCase(String startDate, String endDate,
      String dateTag);

  ArrayList<LawCaseAnalyseResDTO> countMediationAnalyseCase(String startDate, String endDate, String mediationType);
  ArrayList<LawCaseAnalyseResDTO> countFollowMediationAnalyseCase(String startDate, String endDate);


  JSONObject countPeopleMediaCase(String startDate, String endDate);

  JSONObject countPoliceMediaCase(String startDate, String endDate);

  JSONObject countFundGuaranteeStatement(String startDate, String endDate);

  PageInfo getSubsidyCaseReport(String startDate, String endDate, Integer pageSize, Integer pageNum);

  JSONObject getPeopleMediaWorkReport(String startDate, String endDate);

  JSONObject getAreaCaseCount(String startDate, String endDate, String areaCode);

  JSONObject countByPersonalInfo(String startDate, String endDate, String areaCode, String disputeType);

  JSONObject countCaseTimeInfo(String startDate, String endDate, String areaCode);

  List<Integer> getCaseIdsByDate(String startDate, String endDate, String areaCode);

  JSONObject caseAmountInvolved(String startDate, String endDate, String areaCode);

  List<Map<String, Object>> getCaseByInstitution(String startDate, String endDate);

  List<Map<String, Object>> countCaseByArea(String startDate, String endDate, String areaCode);
  ArrayList<CloseCaseTopTenResDTO> getCloseCaseTopTenResDTO(Integer type, String startDate, String endDate);

  List<Map<String, Object>> getUserEvaluateGradeInfo(String startDate, String endDate, String areaCode);

  JSONObject analyseCaseNumByMonthAndOrg(String startDate, String endDate, Integer orgId, String areaCode);

  JSONObject getMediationInfo(String startDate, String endDate, String areaCode);

  JSONObject getCaseGroup(String startDate, String endDate, String areaCode);

}
