package com.beiming.odr.referee.dto.responsedto;

import com.beiming.framework.util.Date2LongSerialize;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.constant.LocaleConst;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * 返回api实体类进度
 * 
 * @author qsh
 * @data 2018年6月29日
 */
@EncryptDecryptData
public class LawProgressResDTO implements Serializable {

  private static final long serialVersionUID = 1L;
  private Long id;
  private Long creatorId;
  private String progressStatus;
  private String progressContent;
  private String progressContentEn;
  private String progressContentTw;
  @EncryptDecryptField
  private String caseNo;
  private Long lawCaseId;
  private String progressJson;
  private String personnels;
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime;

  public static long getSerialVersionUID() {
    return serialVersionUID;
  }

  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public Long getCreatorId() {
    return creatorId;
  }

  public void setCreatorId(Long creatorId) {
    this.creatorId = creatorId;
  }

  public String getProgressStatus() {
    return progressStatus;
  }

  public void setProgressStatus(String progressStatus) {
    this.progressStatus = progressStatus;
  }

  public String getProgressContent() {
    switch (LocaleContextHolder.getLocale().toString().toLowerCase()) {
      case LocaleConst.EN:
        return progressContentEn;
      case LocaleConst.TW:
        return progressContentTw;
      default:
        return progressContent;
    }
  }
  public String progressContent() {
    return progressContent;
  }

  public String getProgressContentEn() {
    return progressContentEn;
  }

  public void setProgressContentEn(String progressContentEn) {
    this.progressContentEn = progressContentEn;
  }

  public String getProgressContentTw() {
    return progressContentTw;
  }

  public void setProgressContentTw(String progressContentTw) {
    this.progressContentTw = progressContentTw;
  }

  public void setProgressContent(String progressContent) {
    this.progressContent = progressContent;
  }

  public String getCaseNo() {
    return caseNo;
  }

  public void setCaseNo(String caseNo) {
    this.caseNo = caseNo;
  }

  public Long getLawCaseId() {
    return lawCaseId;
  }

  public void setLawCaseId(Long lawCaseId) {
    this.lawCaseId = lawCaseId;
  }

  public String getProgressJson() {
    return progressJson;
  }

  public void setProgressJson(String progressJson) {
    this.progressJson = progressJson;
  }

  public String getPersonnels() {
    return personnels;
  }

  public void setPersonnels(String personnels) {
    this.personnels = personnels;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
