package com.beiming.odr.referee.dto.responsedto.haoda;

import com.beiming.odr.referee.dto.requestdto.haoda.ApplyPartyAgent;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 司法确认审核-当事人详情 响应DTO
 * @author xiaoying
 * @date 2022/01/17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseCheckUserResDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * law_case_personnel表主键
   */
  private Long personId;

  /**
   * 案件用户类型（申请人 ,被申请人）
   */
  private String caseUserType;

  /**
   * 用户类型（自然人,法人,非法人组织）
   */
  private String userType;

  /**
   * 用户Id
   */
  private Long userId;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String userName;

  /**
   * 性别
   */
  private String sex;

  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 证件号码
   */
  private String idCard;

  /**
   * 证件图片 当为信用代码时图片为信用代码或营业执照
   * 当事人证件图片名称
   */
  private String cardImage;

  /**
   * 当事人证件图片地址
   */
  private String cardImageUrl;

  /**
   * 信用代码
   */
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;

  /**
   * 手机号码
   */
  private String phone;

  /**
   * 现住地址
   */
  private String currentAddress;

  /**
   * 常住地址
   */
  private String permanentAddress;

  /**
   * 户籍地址
   */
  private String residenceAddress;

  /**
   * 邮寄地址
   */
  private String mailingAddress;

  /**
   * 当事人代理人
   */
  private List<ApplyPartyAgent> agentList;

}