package com.beiming.odr.referee.enums;

/**
 * @Description: 书证类型枚举
 * @Author: caiwei
 * @Date: Created 2018-06-26
 */
public enum DocumentEvidenceTypeEnum {

  /** 身份证证明下资料名称 */
  AUTHORIZE_PROXY("a", "授权委托书"), PARTY_IDENTIFICATION_PAPER("j", "当事人身份证明"), AGENT_IDENTIFICATION_PAPER(
      "c", "代理人身份证明"),
  /** 文书材料 */
  MEDIATION_APPLY_BOOK("h", "调解申请书"), PARTY_DROIT_NOTIFY_BOOK("b", "当事人权利义务告知书"), MEDIATION_RECORD(
      "e", "调解笔录"), INQUIRE_RECORD("m", "调查笔录"), MEDIATION_BOOK("y", "调解协议书"), MEDIATION_AGREEMENT_PERFORM_PROVE(
      "k", "调解协议履行证明"), JUDICIAL_CONFIRM_APPLY_BOOK("l", "司法确认申请书"), DEFAULT_FILE("n", "默认附件"), MEDIATION_VIST_RECORD(
      "f", "调解回访记录"), MEDIATION_EVIDENCE_MATERIAL("d", "调解证据材料"), COMMITMENT_BOOK("o", "承诺书"), NO_DISSENT_MEDIATION_SCHEME(
      "p", "无异议调解方案"), UNDISPUTED_FACT("q", "无争议事实"), DISSENT_RECORD("r", "异议书"), EVIDENCE_INVENTORY(
      "u", "证据清单"), PETITION_AGENT_AUTHORIZE_PROXY("", "信访授权委托书"), GENERAL_AGENT_AUTHORIZE_PROXY(
      "", "一般代理人授权委托书"), PRIVILEGED_AGENT_AUTHORIZE_PROXY("", "特权代理人授权委托书"), OTHER("w", "其他"), SETTLE_CASE_TABLE(
      "z", "结案表"), CLASSIC_CASE("", "经典案例"), LOAN_AGREEMENT("", "借款协议"),
  INTERMEDIARY_SERVICE_AGREEMENT("", "居间服务协议"), PAYMENT_VOUCHERS("", "打款凭证"), DEFENDANT_IDENTITY_INFORMATION("", "被告身份信息"),
  LAW_TERMINATED_PROGRESS("", "正常终结案件调解进度"), FINAL_MEDIATION_REPORT("", "终结调解报告"), RECONCILIATION_AGREEMENT("", "调解书"),
  WITHDRAW_CASE("", "撤回立案"), JUDICIAL_CONFIRM_BOOK("", "司法确认书"), CLOSE_CASE_BOOK("", "诉中结案文书"), COMPRM_SETTLEMENT("", "和解通知书"),
  REMINDER_LETTER("", "催告通知书"), ADDRESS_CONFIRMATION("", "地址确认书"), APPLICATION_MEDIATION("", "调解申请书"),
  MEDIATION_ACCEPT_FORM("", "调解受理登记表"), LITIGATION_BOOK("", "起诉状"),

  PEOPLE_MEDIATION_APPLICATION("", "人民调解申请书"), PEOPLE_MEDIATION_INVESTIGATION_RECORD("",
      "人民调解调查记录"), PEOPLE_MEDIATION_EVIDENCE("", "人民调解证据材料"), PEOPLE_MEDIATION_RECORD("",
      "人民调解记录"), PEOPLE_MEDIATION_AGREEMENT("", "人民调解协议书"), PEOPLE_MEDIATION_VISIT_RECORD("",
      "人民调解回访记录"), PEOPLE_MEDIATION_JUDICIAL_CONFIRMATION("", " 司法确认有关材料（若有）"), DOSSIER_DESCRIPTION(
      "", "卷宗情况说明"), PEOPLE_MEDIATION_ACCEPTANCE_FORM("",
      "人民调解受理登记表"), PEOPLE_MEDIATION_AGREEMENT_FORM("", "人民调解口头协议登记表");

  private String code;

  private String name;

  /**
   * @param code
   * @param name
   */
  private DocumentEvidenceTypeEnum(String code, String name) {
    this.code = code;
    this.name = name;
  }

  public String getCode() {
    return code;
  }

  public String getName() {
    return name;
  }

  public static DocumentEvidenceTypeEnum getByName(String name) {
    if (name == null) {
      return DocumentEvidenceTypeEnum.OTHER;
    }
    for (DocumentEvidenceTypeEnum documentEvidenceTypeEnum : values()) {
      if (documentEvidenceTypeEnum.name().equalsIgnoreCase(name)) {
        return documentEvidenceTypeEnum;
      }
    }
    return DocumentEvidenceTypeEnum.OTHER;
  }
}
