package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.requestdto.AppointmentApiReqDTO;
import com.beiming.odr.referee.dto.requestdto.RemarkApiReqDTO;
import com.beiming.odr.referee.dto.responsedto.AppointmentBookingResDTO;
import com.beiming.odr.referee.dto.responsedto.AppointmentMeetingResDTO;

import com.beiming.odr.referee.dto.responsedto.AppointmentWaitAssResDTO;
import javax.validation.Valid;
import java.util.ArrayList;

@Valid
public interface AppointmentApi {

  /**
   * 查找未确认的文书列表
   */
  DubboResult<ArrayList<AppointmentBookingResDTO>> getBookList(AppointmentApiReqDTO appointmentApiReqDTO);

  /**
   * 获取未结束会议列表
   */
  DubboResult<ArrayList<AppointmentMeetingResDTO>> getMeetingList(AppointmentApiReqDTO appointmentApiReqDTO);

  /**
   * 获取调解员的案件列表
   */
//  ArrayList listMediationInfo(AppointmentApiReqDTO appointmentApiReqDTO);

  DubboResult<ArrayList<AppointmentWaitAssResDTO>> getWaitAssignCaseList(AppointmentApiReqDTO appointmentApiReqDTO);

  DubboResult<ArrayList<AppointmentWaitAssResDTO>> getWaitMedList(AppointmentApiReqDTO appointmentApiReqDTO);

  Integer addRemark(RemarkApiReqDTO remarkApiReqDTO);

  //更新修改备注
  DubboResult<Integer> updateRemark(RemarkApiReqDTO remarkApiReqDTO);

  ArrayList getRemarkList(AppointmentApiReqDTO appointmentApiReqDTO);

  //待受理
  DubboResult<ArrayList<AppointmentWaitAssResDTO>> getWaitAccList(AppointmentApiReqDTO appointmentApiReqDTO);

  //需回访
  DubboResult<ArrayList<AppointmentWaitAssResDTO>> getVisitCaseList(AppointmentApiReqDTO appointmentApiReqDTO);
  //需跟进
  DubboResult<ArrayList<AppointmentWaitAssResDTO>> getWaitFollowCaseList(AppointmentApiReqDTO appointmentApiReqDTO);
  //需推送
  DubboResult<ArrayList<AppointmentWaitAssResDTO>> getWaitPushWCaseList(AppointmentApiReqDTO appointmentApiReqDTO);
  //待跟进
  DubboResult<ArrayList<AppointmentWaitAssResDTO>> getOrgWaitFollowCaseList(AppointmentApiReqDTO appointmentApiReqDTO);
}
