package com.beiming.odr.referee.api;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import com.beiming.framework.domain.DubboResult;

import com.beiming.odr.referee.dto.requestdto.MeetingNewSaveReqDTO;

/**
 * 新会议接口
 * 
 * @author qsh
 * @data 2018年10月22日
 */
@Valid
@SuppressWarnings("rawtypes")
public interface CaseMeetingNewApi {
  /**
   * 保存新会议
   *
   * @param caseMeetingSaveReqDTO
   * @return
   */
  DubboResult caseNewMeetingSave(@Valid MeetingNewSaveReqDTO meetingNewSaveReqDTO);

  /**
   * 网关调更新会议结束时间
   * 
   * @param meetingNewSaveReqDTO
   * @return
   */
  DubboResult updateCaseMeeting(@Valid @NotNull(
      message = "{conference.id.cannot.be.empty}") String roomId);
  
  /**
   *  网关调更 开始时间更新
   *
   * @param meetingId
   * @return
   */
  DubboResult<Boolean> updateMeetingStartTime(@Valid @NotNull(
      message = "{conference.id.cannot.be.empty}") String roomId);
}
