package com.beiming.odr.referee.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Auther: Administrator
 * @Date: 2019/5/16/016 12:29
 * @Description:
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class SuitAgentDTO implements Serializable {
  //序号
  @JsonProperty("ssdlrxh")
  private String number;
  //辩护类型
  @JsonProperty("bhlx")
  private String defenseType;
  //姓名
  @JsonProperty("dlrmc")
  private String name;
  //联系电话
  @JsonProperty("dlrlxdh")
  private String phone;
  //邮政编码
  @JsonProperty("dlryzbm")
  private String postalCode;
  //地址
  @JsonProperty("dlrdz")
  private String address;
  //代理人执业证号
  @JsonProperty("zyzjhm")
  private String licenseNumber;
  //证件类型
  @JsonProperty("dlrzjzl")
  private String certificateType;
  //证件号码
  @JsonProperty("dlrzjhm")
  private String cardNum;
  //代理人所在单位，非必填",
  @JsonProperty("dlrszdw")
  private String unit;
  //代理人所在单位，非必填"
  @JsonProperty("dldsrxh")
  private String litigantNum;

  public SuitAgentDTO(String phone, String cardNum, String name, String number, String address) {
    this.certificateType = "09_00015-1"; //代理人只有身份证
    this.phone = phone;
    this.cardNum = cardNum;
    this.name = name;
    this.number = number;
    this.address = address;
  }

}
