package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 纠纷专题统计
 * @Date: Created 2018-11-07 12:12
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DisputeSubjectStatisticsReqDTO implements Serializable {

  private static final long serialVersionUID = -5600251953659639523L;

  public DisputeSubjectStatisticsReqDTO(String startDate, String endDate) {
    this.startDate = startDate;
    this.endDate = endDate;
  }

  /**
   * 纠纷发生区域
   */
  private String areaCode;

  /**
   * 纠纷code
   */
  private String disputeCode;

  /**
   * 开始时间
   */
  private String startDate;

  /**
   * 结束时间
   */
  private String endDate;

  /**
   * 纠纷发生区域(多选)
   */
  private List<String> areaCodes;
  /**
   * 禁用的机构信息
   */
  private List<Long> disableOrgIds;
}
