package com.beiming.odr.referee.dto.requestdto.shewai;


import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author yi.liu
 */
@Data
public class LawAttachmentDTO implements Serializable {

  private static final long serialVersionUID = -79748468548640386L;

  /**
   * 文件名
   */
  private String fileName;

  /**
   * 文件fileid
   */
  private String fileId;

  /**
   * 上传者id
   */
  private Long personnelId;

  /**
   * 附件大分类( 调解用，诉讼用，司法确认用等)
   */
  private String categoryBig;

  /**
   * 附件中分类(书证、物证、等等)
   */
  private String categoryMiddle;

  /**
   * 附件小分类(备用)
   */
  private String categorySmall;

  /**
   * 类型
   */
  private String objectType;

  /**
   * 对应表主键id
   */
  private Long objectId;

  /**
   * 当类型为书证时,sign为详细小分类0默认附件 1调谐协议书;2 调解笔录;3调查笔录;4司法确认申请书;5调解申请书;6当事人权利义务告知书;7授权委托书;8调解协议履行证明;9调解回访记录;10结案表;
   */
  private String sign;

  /**
   * 会议Id
   */
  private Long meetingId;

  /**
   * 预览url
   */
  private String previewUrl;

  /**
   * 案件人员id
   */
  private Long caseUserId;
  /**
   * 通达海文件id
   */
  private String tdhFileId;
  /**
   * 下载地址
   */
  private String downloadUrl;
  private Long id;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 状态 0 正常 1 删除
   */
  private Integer status;

  /**
   * 备注
   */
  private String remark;
}

