package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * 纠纷统计下钻案件列表返回对象
 *
 * @author liubao
 * @date 2024/08/01
 */
@Data
@ApiModel(description = "纠纷统计下钻案件列表返回对象")
@EncryptDecryptData
public class DisputeStatisticsDetailRespDTO implements Serializable {

  private static final long serialVersionUID = -4481447316302659990L;

  @ApiModelProperty(value = "案件唯一id")
  private Long id;

  @ApiModelProperty(value = "案号")
  @EncryptDecryptField
  private String caseNo;

  @ApiModelProperty(value = "立案日期")
  private String larq;

  @ApiModelProperty(value = "结案日期")
  private String jarq;

  @ApiModelProperty(value = "调解案件返回案件process，诉讼仲裁是案件状态名称")
  private String lawStatus;

  @ApiModelProperty(value = "承办人")
  private String cbr;
}
