package com.beiming.odr.referee.dto.responsedto.haoda;


import com.beiming.odr.referee.dto.CardTypeDTO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 司法确认审核案件详情 响应DTO
 * @author xiaoying
 * @date 2022/01/17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseCheckDetailResDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 主键
   */
  private Long id;

  /**
   * 案件Id
   */
  private Long lawCaseId;

  /**
   * 法院id
   */
  private String courtCode;

  /**
   * 法院名称
   */
  private String courtName;

  /**
   * 法院列表
   */
  private List<CourtResDTO> courtList;

  /**
   * 申请人类型
   */
  private Integer applyUserType;

  /**
   * 申请人id
   */
  private Long applyUserId;

  /**
   * 类型id
   */
  private Long caseTypeId;

  /**
   * 类型名称
   */
  private String caseTypeName;

  /**
   * 案件列表类型
   */
  private List<CaseTypeResDTO> caseTypeList;

  /**
   * 是否涉及疫情
   */
  private Integer isEpidemicSituation;

  /**
   * 是否财产保全
   */
  private Integer isPropertyPreservation;

  /**
   * 纠纷金额
   */
  private String disputeMoney;

  /**
   * 纠纷物品
   */
  private String disputeGoods;

  /**
   * 纠纷行为
   */
  private String disputeBehavior;

  /**
   * 案由编码
   */
  private String disputeCodeId;

  /**
   * 案由名称
   */
  private String disputeCodeName;

  /**
   * 诉求
   */
  private String disputeAppeal;

  /**
   * 事实与理由
   */
  private String reason;

  /**
   * 备注
   */
  private String remark;

  /**
   * 状态 1 正常 0 删除
   */
  private Integer status;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 版本号
   */
  private Integer version;

  /**
   * 1等待审核 2审核通过 3审核失败
   */
  private Integer checkState;

  /**
   * 案件-当事人信息
   */
  private List<CaseCheckUserResDTO> checkUserList;

  /**
   * 0草稿 1正常 2作废
   */
  private Integer draft;

  /**
   * 常规文书材料
   */
  private List<DocumentResDTO> documentList;

  /**
   * 司法确认文书材料
   */
  private List<DocumentListResDTO> judicialDocumentList;

  /**
   * 证件类型
   */
  private List<CardTypeDTO> cardTypeList;

  /**
   * 案件提交状态
   * 0是未提交  1是暂存 2已提交
   */
  private Integer caseStatus;

  /**
   * 审核内容
   */
  private String checkContent;

}