package com.beiming.odr.referee.dto.thirdparty;

import com.beiming.odr.referee.enums.CategoryBigTypeEnum;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by Jache on 2020/04/14 20:04.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class RoutingCaseDocument implements Serializable {

  private static final long serialVersionUID = 1199986934547065137L;
  /**
   * 文件标识
   */
  private String documentFileId;
  /**
   * 文件名，带格式
   */
  private String documentFileName;
  /**
   * 下载url，时效性48小时
   */
  private String downloadUrl;

  /**
   * 文件类型
   */
  private CategoryBigTypeEnum documentType;

  /**
   * 唯一随机码，用于返回文件标识时找到对应关系
   */
  private String index;

  public RoutingCaseDocument(String index, String documentFileId) {
    this.index = index;
    this.documentFileId = documentFileId;
  }
}
