package com.beiming.odr.referee.enums;

import java.util.ArrayList;
import java.util.List;
import com.beiming.odr.referee.dto.MediationCaseProgressDTO;

/**
 * @Description: 案件进度枚举
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseProgressEnum {
  TRANSFER("已转移"), APPLY("提交申请"), REFUSE("已退回"), WAIT("等待调解"),
  RETRACT("撤回调解"), START("正在调解"), FAIL("调解失败"), SUCCESS("调解成功"),
  JUDICIAL("司法确认"), ONLINE("网上立案"), TURN("已流转"),

  /**
   * 以下状态为查询所用，不记录进数据库
   */
  WAIT_CONFIRM("待受理"), BEGIN("调解开始"), WAIT_ASSGIN("待分配"),
  WAIT_HANDLE("处理中"),
  WAIT_PUSH("需推送"), WAIT_FOLLOW("待跟进"), FOLLOW_END("已跟进");

  private String name;

  CaseProgressEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  /**
   * 返回包含当前案件状态和案件状态列表
   *
   * @return
   */
  public static List<MediationCaseProgressDTO> getCaseProgressList(CaseProgressEnum enumObj) {
    List<MediationCaseProgressDTO> lst = new ArrayList<MediationCaseProgressDTO>();
    setCaseProgress(lst, CaseProgressEnum.APPLY, enumObj, 1, false); // 提交申请
    setCaseProgress(lst, CaseProgressEnum.WAIT_CONFIRM, enumObj, 2, false); // 待受理
    setCaseProgress(lst, CaseProgressEnum.REFUSE, enumObj, 3, true); // 不受理
    //  只是用来查询，
    // setCaseProgress(lst, CaseProgressEnum.BEGIN, enumObj, 4, false); // 调解开始，
    setCaseProgress(lst, CaseProgressEnum.WAIT, enumObj, 4, true); // 等待调解、调解开始
    setCaseProgress(lst, CaseProgressEnum.TURN, enumObj, 5, true); // 已转移
    setCaseProgress(lst, CaseProgressEnum.TRANSFER, enumObj, 5, true); // 已转移
    setCaseProgress(lst, CaseProgressEnum.RETRACT, enumObj, 6, true); // 撤回调解
    setCaseProgress(lst, CaseProgressEnum.START, enumObj, 7, true); // 正在调解
    setCaseProgress(lst, CaseProgressEnum.FAIL, enumObj, 8, true); // 调解失败
    setCaseProgress(lst, CaseProgressEnum.SUCCESS, enumObj, 9, true); // 调解成功

    setCaseProgress(lst, CaseProgressEnum.JUDICIAL, enumObj, 10, true); // 司法确认
    setCaseProgress(lst, CaseProgressEnum.ONLINE, enumObj, 11, true); // 网上立案
    return lst;
  }

  /**
   * 设置案件进度
   *
   * @param lst        结果列表
   * @param enumX      需要植入的进度状态
   * @param enumY      当前案件进度状态(可NULL)
   * @param order      排序
   * @param hiddenFlag 是否默认隐藏
   * @return
   */
  private static List<MediationCaseProgressDTO> setCaseProgress(List<MediationCaseProgressDTO> lst,
      CaseProgressEnum enumX, CaseProgressEnum enumY, int order, Boolean hiddenFlag) {
    Boolean flag = false;
    if (enumY != null) {
      flag = enumX.name().equals(enumY.name());
    }
    MediationCaseProgressDTO caseProgressDTO = new MediationCaseProgressDTO(enumX.name(),
        enumX.getName(), (hiddenFlag && flag) ? false : hiddenFlag, flag, order);
    lst.add(caseProgressDTO);
    return lst;
  }

  /**
   * 进度判断的方法
   */
  public static Boolean checkProgress(List<CaseProgressEnum> list, String value, String operate) {
    Boolean result = false;
    for (CaseProgressEnum caseProgressEnum : list) {
      if ("and".equals(operate) && !caseProgressEnum.name().equals(value)) { // 匹配到不相等的。
        return false;
      }
      if ("or".equals(operate) && caseProgressEnum.name().equals(value)) { // 匹配到相等的。
        return true;
      }
    }
    //经过循环之后。
    if ("and".equals(operate)) {
      result = true;
    }
    return result;
  }

  //通过英文code返回类型的中文名
  public static String getCodeName(String code) {
    String codeName = "未知";
    try {
      codeName = CaseProgressEnum.valueOf(code).getName();
    } catch (Exception e) {
    }
    return codeName;
  }

}
