package com.beiming.odr.referee.api.gongdao;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.GDNoticeDocumentDTO;
import com.beiming.odr.referee.dto.GDOnlineCourtDTO;
import com.beiming.odr.referee.dto.requestdto.GDQuerySchedulReqDTO;
import com.beiming.odr.referee.dto.requestdto.document.GDNoticeDocumentRequestDTO;
import java.util.ArrayList;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * Created by Jache on 2019/01/17 19:55.
 */
@Valid
public interface GongdaoPushApi {

  DubboResult syncMediationSuccessOrFailStatus(
      @NotNull(message = "案件id不能为空") Long caseId, String mediationStatusToGd, String userName);
  
  /*** 获取共道的法院信息*/
  DubboResult<ArrayList<GDOnlineCourtDTO>> getGDOnlineCourtData(GDQuerySchedulReqDTO req);

  /** 获取共道返回的案件当事人文书信息
   * @return*/
  DubboResult<ArrayList<GDNoticeDocumentDTO>> getNoticeDocuments(GDNoticeDocumentRequestDTO requestDTO);

  /**
   * 案件调解成功后手动申请撤诉
   */
  DubboResult applyWithdraw(Long lawCaseId, String userName);
}
