package com.beiming.odr.referee.dto;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.dto.requestdto.CaseProtocolAgentPersonnelReqDTO;
import com.beiming.odr.referee.enums.AgentTypeEnum;
import com.beiming.odr.referee.enums.RegisterOriginEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Auther: JACHE
 * @Date: 2019/6/3/003 15:50
 * @Description: 代理人實體
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@EncryptDecryptData
public class MediationCaseAgentPersonnelDTO implements Serializable {

  private static final long serialVersionUID = 5034947034091521279L;
  private Long id;
  private String citeAgentId; //引调代理人id'
  private String agentName; // 代理人名称
  private String defenseType; //辩护类型
  private Long lawCaseId; //案件id'
  private Long userId; //用户id
  private Long litigantId; //当事人id
  private Long litigantPersonId; //当事人用户表id
  private String litigantCaseUserType; //案件用户类型（申请人 ,被申请人）
  private String litigantName; //当事人名称
  private String sex; //性别'
  private String nation; //民族
  private String nationality; //国籍
  /**
   * 国籍中文名称
   */
  private String nationalityName;
  /**
   * 民族中文名称
   */
  private String nationName;
  /**
   * 证件类型中文名称
   */
  private String cardTypeName;
  @EncryptDecryptField
  private String lawyerCardNum; //律师证件号
  @EncryptDecryptField
  private String phone; //联系电话
  @EncryptDecryptField
  private String idCard;  //身份证号码
  private String cardType;  //证件类型
  private Integer userOrder; //排序
  private String userRegisterOrigin;  //用户注册来源（默认平台注册）
  private String approvalStatus; //通达海审批状,
  private String agentType; //代理人类型'
  @EncryptDecryptField
  private String telephone; //固定电话'
  private String email; //邮件地址'
  @EncryptDecryptField
  private String address; //地址
  private Boolean isApprovalWaiting;  // 是否待审批：true=待审批，false=无需审批
  private MediationCaseAgentPersonnelBriefDTO latestModify; // 最新修改
  private Long auditId;
  private Boolean agentRepairFlag; //是否可失联修复标识
  private List<String> sparePhone; //备用号码

  public static CaseProtocolAgentPersonnelReqDTO caseProtocolAgentPersonnelReqDTOConvert(MediationCaseAgentPersonnelDTO agent) {
    CaseProtocolAgentPersonnelReqDTO dto = new CaseProtocolAgentPersonnelReqDTO();
    dto.setAgentName(agent.getAgentName());
    dto.setCiteAgentId(agent.getCiteAgentId());
    dto.setUserId(agent.getUserId());
    dto.setSex(StringUtils.isEmpty(agent.getSex()) ? null : UserSexEnum.valueOf(agent.getSex()));
    dto.setNation(agent.getNation());
    dto.setNationality(agent.getNationality());
    dto.setLawyerCardNum(agent.getLawyerCardNum());
    dto.setPhone(agent.getPhone());
    dto.setIdCard(agent.getIdCard());
    dto.setCardType(agent.getCardType());
    dto.setUserOrder(agent.getUserOrder());
    dto.setUserRegisterOrigin(StringUtils.isEmpty(agent.getUserRegisterOrigin()) ? null : RegisterOriginEnum
        .valueOf(agent.getUserRegisterOrigin()));
    dto.setAgentType(StringUtils.isEmpty(agent.getAgentType()) ? null : AgentTypeEnum.valueOf(agent.getAgentType()));
    dto.setTelephone(agent.getTelephone());
    dto.setEmail(agent.getEmail());
    dto.setAddress(agent.getAddress());
    dto.setId(agent.getId());
    dto.setLitigantId(agent.getLitigantId());
    dto.setLitigantName(agent.getLitigantName());
    dto.setApprovalStatus(agent.getApprovalStatus());
    dto.setLitigantPersonId(agent.getLitigantPersonId());
    dto.setLitigantCaseUserType(agent.getLitigantCaseUserType());
    dto.setLawCaseId(agent.getLawCaseId());
    dto.setNationalityName(agent.getNationalityName());
    dto.setNationName(agent.getNationName());
    dto.setCardTypeName(agent.getCardTypeName());
    return dto;
  }
}