package com.beiming.odr.referee.dto.requestdto;

import java.io.Serializable;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

/**
 * 导入案件列表入参请求
 * 
 * @author qsh
 *
 * @2019年3月1日
 */
@Data
public class LawCaseImportSaveReqDTO implements Serializable {


  private static final long serialVersionUID = -5075520039470716598L;

  /**
   * 原编号
   */
  private String originalCaseNo;

  /**
   * 原文件名
   */
  private String originalFileName;


  /**
   * 登记人
   */
  private String registrant;


  /**
   * 登记时间 由于模板时间不统一
   */
  private String registrantTime;

  /**
   * 处理机构
   */
  private String processingOrgName;

  /**
   * law_case表id
   */
  private Long lawCaseId;

  /**
   * 模板大类目录
   */
  private String categoryDirectory;

  /**
   * 模板枚举
   */
  private String templateEnum;


  private Long creatorId;

  private String createUser;

  @Value("0")
  private int isSuspend;

  @Value("0")
  private int suspendNum;
}
