package com.beiming.odr.referee.dto.requestdto.haoda;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 司法确认和网上立案 昊达返回审核结果
 * @author xiaoying
 * @date 2022/01/14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CheckResultDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 案件Id
   */
  private String caseId;

  /**
   * 文书url地址
   */
  private String writUrl;

  /**
   * 文书名称
   */
  private String writName;

  /**
   * 用户Id
   */
  private String userId;

  /**
   * 司法确认或网上立案审核结果  1成功 2失败
   */
  private String result;

  /**
   * 失败时备注原因
   */
  private String remark;

  /**
   * 是司法确认还是网上立案
   * 1 网上立案 2 司法确认
   */
  private String type;

  /**
   * 诉讼金额
   */
  private String suitMoney;
}