package com.beiming.odr.referee.dto.responsedto;

import com.beiming.framework.util.StringUtils;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.dto.MediationCaseAgentPersonnelDTO;
import com.beiming.odr.referee.dto.requestdto.CaseProtocolAgentPersonnelReqDTO;
import com.beiming.odr.referee.enums.AgentTypeEnum;
import com.beiming.odr.referee.enums.RegisterOriginEnum;
import com.beiming.odr.referee.enums.UserSexEnum;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Auther: JACHE
 * @Date: 2019/6/3/003 15:50
 * @Description: 代理人實體
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@EncryptDecryptData
public class CaseProtocolAgentPersonnelResDTO implements Serializable {

  private static final long serialVersionUID = -7563385091999158865L;
  private Long id;

  private String citeAgentId; //引调代理人id

  private String agentName; //代理人姓名

  private String defenseType; //辩护类型

  private Long lawCaseId; //案件id

  private Long userId; //用户id

  private Long litigantId; //当事人id

  private Long litigantPersonId; //当事人用户表id

  private String litigantCaseUserType; //案件用户类型（申请人 ,被申请人）

  private String litigantName; //当事人名称

  private String sex; //性别

  private String nation; //民族

  private String nationality; //国籍

  @EncryptDecryptField
  private String lawyerCardNum; //律师证件号

  @EncryptDecryptField
  private String phone; //联系电话

  @EncryptDecryptField
  private String idCard;  //身份证号码

  private String cardType;  //证件类型

  private Integer userOrder; //排序

  private String userRegisterOrigin; //用户注册来源

  private String approvalStatus; //通达海审批状态

  private String agentType; //代理人类型

  @EncryptDecryptField
  private String telephone; //固定电话

  private String email; //邮件地址

  @EncryptDecryptField
  private String address;

  private String extendJson;

  public static CaseProtocolAgentPersonnelReqDTO caseProtocolAgentPersonnelReqDTOConvert(
      CaseProtocolAgentPersonnelResDTO agent) {
    CaseProtocolAgentPersonnelReqDTO dto = new CaseProtocolAgentPersonnelReqDTO();
    dto.setId(agent.getId());
    dto.setLitigantId(agent.getLitigantId());
    dto.setLitigantName(agent.getLitigantName());
    dto.setAgentName(agent.getAgentName());
    dto.setCiteAgentId(agent.getCiteAgentId());
    dto.setUserId(agent.getUserId());
    dto.setSex(StringUtils.isEmpty(agent.getSex()) ? null : UserSexEnum.valueOf(agent.getSex()));
    dto.setNation(agent.getNation());
    dto.setNationality(agent.getNationality());
    dto.setLawyerCardNum(agent.getLawyerCardNum());
    dto.setPhone(agent.getPhone());
    dto.setIdCard(agent.getIdCard());
    dto.setCardType(agent.getCardType());
    dto.setUserOrder(agent.getUserOrder());
    dto.setUserRegisterOrigin(StringUtils.isEmpty(agent.getUserRegisterOrigin()) ? null : RegisterOriginEnum
        .valueOf(agent.getUserRegisterOrigin()));
    dto.setAgentType(StringUtils.isEmpty(agent.getAgentType()) ? null : AgentTypeEnum.valueOf(agent.getAgentType()));
    dto.setTelephone(agent.getTelephone());
    dto.setEmail(agent.getEmail());
    dto.setAddress(agent.getAddress());
    dto.setApprovalStatus(agent.getApprovalStatus());
    dto.setLitigantPersonId(agent.getLitigantPersonId());
    dto.setLitigantCaseUserType(agent.getLitigantCaseUserType());
    dto.setLawCaseId(agent.getLawCaseId());
    return  dto;
  }

  public CaseProtocolAgentPersonnelResDTO(MediationCaseAgentPersonnelDTO agent) {
    this.id = agent.getId();
    this.litigantId = agent.getLitigantId();
    this.litigantName = agent.getLitigantName();
    this.agentName = agent.getAgentName();
    this.citeAgentId = agent.getCiteAgentId();
    this.userId = agent.getUserId();
    this.sex = StringUtils.isEmpty(agent.getSex()) ? null : UserSexEnum.valueOf(agent.getSex()).name();
    this.nation = agent.getNation();
    this.nationality = agent.getNationality();
    this.lawyerCardNum = agent.getLawyerCardNum();
    this.phone = agent.getPhone();
    this.idCard = agent.getIdCard();
    this.cardType = agent.getCardType();
    this.userOrder = agent.getUserOrder();
    this.userRegisterOrigin = StringUtils.isEmpty(agent.getUserRegisterOrigin()) ? null : RegisterOriginEnum.valueOf(agent.getUserRegisterOrigin()).name();
    this.agentType = StringUtils.isEmpty(agent.getAgentType()) ? null : AgentTypeEnum.valueOf(agent.getAgentType()).name();
    this.telephone = agent.getTelephone();
    this.email = agent.getEmail();
    this.address = agent.getAddress();
    this.approvalStatus = agent.getApprovalStatus();
    this.litigantPersonId = agent.getLitigantPersonId();
    this.litigantCaseUserType = agent.getLitigantCaseUserType();
    this.lawCaseId = agent.getLawCaseId();
  }
}
