package com.beiming.odr.referee.dto.responsedto;

import com.beiming.odr.referee.dto.CaseVisitDTO;
import com.beiming.odr.user.api.common.utils.Java8DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;

/**
 * @author caiyuanxin
 * @date 2021/05/14
 */
@Data
@ApiModel(value = "案件回访返回参数")
public class CaseVisitResponseDTO implements Serializable {

  @ApiModelProperty
  private Long caseId;

  @ApiModelProperty(notes = "是否回访", required = true)
  private Integer visitStatus;

  @ApiModelProperty(notes = "登记时间", required = true)
  private String registerDate;

  @ApiModelProperty(notes = "申请人")
  private String applicant;

  @ApiModelProperty(notes = "申请人ID")
  private String applicantId;

  @ApiModelProperty(notes = "申请人电话")
  private String applicantPhone;

  @ApiModelProperty(notes = "被申请人")
  private String respondent;

  @ApiModelProperty(notes = "被申请人ID")
  private String respondentId;

  @ApiModelProperty(notes = "被申请人电话")
  private String respondentPhone;

  @ApiModelProperty(notes = "申请人回访情况记录")
  private String applicantVisitContent;

  @ApiModelProperty(notes = "被申请人回访情况记录")
  private String respondentVisitContent;

  @ApiModelProperty(notes = "申请人协议履行情况")
  private String applicantPerformance;

  @ApiModelProperty(notes = "被申请人协议履行情况")
  private String respondentPerformance;

  @ApiModelProperty(value = "创建时间")
  private String createTime;

  public CaseVisitResponseDTO() {
    super();
  }

  public CaseVisitResponseDTO(CaseVisitDTO caseVisitDTO) {
    super();
    this.caseId = caseVisitDTO.getCaseId();
    this.visitStatus = caseVisitDTO.getVisitStatus();
    this.registerDate = caseVisitDTO.getRegisterDate();
    this.applicant = caseVisitDTO.getApplicant();
    this.applicantPhone = caseVisitDTO.getApplicantPhone();
    this.respondent = caseVisitDTO.getRespondent();
    this.respondentPhone = caseVisitDTO.getRespondentPhone();
    this.applicantVisitContent = caseVisitDTO.getApplicantVisitContent();
    this.applicantPerformance = caseVisitDTO.getApplicantPerformance();
    this.respondentVisitContent = caseVisitDTO.getRespondentVisitContent();
    this.respondentPerformance = caseVisitDTO.getRespondentPerformance();
    this.applicantId = caseVisitDTO.getApplicantId();
    this.respondentId = caseVisitDTO.getRespondentId();
    this.createTime = Java8DateUtil.formatter(caseVisitDTO.getCreateTime(), "yyyy-MM-dd HH:mm:ss");
  }
}

