package com.beiming.odr.referee.dto.responsedto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.dto.requestdto.LawCaseSubsidyFileDTO;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

@Data
public class LawCaseSubsidyResDTO implements Serializable {

  /**
   * 申请ID
   */
//  @ExcelProperty(value = "申请ID", index = 0)
  @ExcelIgnore
  private Long id;

  /**
   * 案件ID
   */
  @ExcelProperty(value = "案件ID", index = 1)
  private Long lawCaseId;

  /**
   * 案件编号
   */
  @EncryptDecryptField
  @ExcelProperty(value = "案件编号", index = 2)
  private String caseNo;

  /**
   * 审核状态
   */
  @ExcelProperty(value = "审核状态", index = 3)
  private String auditStatus;

  /**
   * 金额
   */
  @ExcelProperty(value = "金额", index = 4)
  private BigDecimal amount;

  /**
   * 到账状态 0未到账 1已到账
   */
  @ExcelProperty(value = "到账状态 ", index = 5)
  private Integer confirmStatus;

  /**
   * 纠纷类型
   */
  @ExcelProperty(value = "纠纷类型", index = 6)
  private String disputeType;

  /**
   * 涉案金额
   */
  @ExcelProperty(value = "涉案金额", index = 7)
  private String caseAmount;

  /**
   * 案件标签
   */
  @ExcelProperty(value = "案件标签", index = 8)
  private String caseTag;

  /**
   * 区域编码
   */
  @ExcelIgnore
  private String areaCode;

  /**
   * 创建人ID
   */
  @ExcelIgnore
  private Long createId;

  /**
   * 创建时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ExcelProperty(value = "创建时间", index = 9)
  private Date createTime;

  /**
   * 创建人
   */
  @ExcelProperty(value = "创建人", index = 10)
  private String createUser;


  /**
   * 备注
   */
  @ExcelProperty(value = "备注", index = 11)
  private String remark;

  /**
   * 文件信息
   */
  @JsonIgnore
  @ExcelIgnore
  private String fileJson;

  /**
   * 文件信息
   */
  @ExcelIgnore
  private List<LawCaseSubsidyFileDTO> files;



  /**
   * 卷宗审核时间
   */
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @ExcelIgnore
  private Date dossierAuditTime;
}
