package com.beiming.odr.referee.dto.thirdparty;

import com.beiming.odr.referee.enums.CaseStatusEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import lombok.Data;

/**
 * Created by Jache on 2020/04/14 19:51.
 */
@Data
public class RoutingCase implements Serializable {

  private static final long serialVersionUID = -2445146506057899261L;
  /**
   * 案件标识
   */
  private Long caseCode;

  /**
   * 案件编号
   */
  private String caseNo;

  /**
   * 案件状态
   */
  private CaseStatusEnum caseStatus;

  /**
   * 开始调解时间
   */
  private Date startTime;

  /**
   * 结束调解时间
   */
  private Date endTime;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 机构标识
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 诉求
   */
  private String appeal;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  /**
   * 纠纷金额
   */
  private String disputeAmount;

  /**
   * 和解金额
   */
  private String cprmAmount;

  /**
   * 申请人信息
   */
  private List<RoutingCasePerson> applicants;

  /**
   * 被申请人信息
   */
  private List<RoutingCasePerson> respondents;

  /**
   * 证据信息
   */
  private List<RoutingCaseDocument> documents;
}
