package com.beiming.odr.referee.enums;

/**
 * 不受理类型枚举
 * 
 * @author qsh
 * @data 2018年7月20日
 */
public enum CaseDeclinedEnum {
  /**
   * 非本机构管辖
   */
  NOT_ORGANIZATION("非本机构管辖"),
  /**
   * 其他机构已受理/解决
   */
  OTHER_ORGANIZATION_ACCEPTED("其他机构已受理/解决"),

  /**
   * 依案件性质不予调解
   */
  NO_MEDIATION_ACCORDING("依案件性质不予调解"),
  /**
   * 其他原因
   */
  OTHER_REASON("其他原因");

  private String name;

  /**
   * @param name
   */
  private CaseDeclinedEnum(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

}
