package com.beiming.odr.referee.enums;

import com.google.common.collect.Lists;
import java.util.List;

/**
 * @Description: 案件用户类型
 * @Author: caiwei
 * @Date: Created 2018-06-21
 */
public enum CaseUserTypeEnum {
  APPLICANT("申请人", "15_Z00099-4", "DSRDW_001", "application", "申請人"),
  RESPONDENT("被申请人", "15_Z00099-5", "DSRDW_002", "respondent", "被申請人"),
  MEDIATOR("调解员", "", "", "mediator", "調解員"),

  APPLICANT_AGENT("申请人代理人", "", "DSRDW_003", "applicationAgent", "申請人代理人"),
  RESPONDENT_AGENT("被申请人代理人", "", "DSRDW_004", "respondentAgent", "被申請人代理人"),
  PETITION_AGENT("信访代理人", "", "", "petitionAgent", "信訪代理人"),

  GENERAL_AGENT("一般代理人", "", "", "generalAgent", "一般代理人"),
  PRIVILEGE_AGENT("特权代理人", "", "", "privilegeAgent", "特權代理人"),

  // 暂时没啥用
  APPLICANT_GENERAL_AGENT("申请人一般代理人", "", "", "applicationGengalAgent", "申請人一般代理人"),
  APPLICANT_PRIVILEGE_AGENT("申请人特权代理人", "", "", "applicantPrivilegeAgent", "申請人特權代理人"),
  RESPONDENT_GENERAL_AGENT("被申请人一般代理人", "", "", "respondentGeneralAgent", "被申請人一般代理人"),
  RESPONDENT_PRIVILEGE_AGENT("被申请人特权代理人", "", "", "respondentPrivilegeAgent", "被申請人特權代理人"),
  // ------ 分割线

  MEDIATOR_HELP("协助调解员", "", "", "mediatorHelp", "協助調解員"),
  MEDIATOR_HELP_TEMPORARY("临时协助调解员", "", "", "mediatorHelpTemporary", "臨時協助調解員"),
  ;

  private String name;
  private String tdhCode;
  private String infoCollectCode;
  private String enName;
  private String twName;

  CaseUserTypeEnum(String name, String tdhCode, String infoCollectCode, String enName, String twName) {
    this.name = name;
    this.tdhCode = tdhCode;
    this.infoCollectCode = infoCollectCode;
    this.enName = enName;
    this.twName = twName;
  }

  public String getInfoCollectCode() {
    return infoCollectCode;
  }

  public String getName() {
    return name;
  }

  public String getTdhCode() {
    return tdhCode;
  }

  public void setTdhCode(String tdhCode) {
    this.tdhCode = tdhCode;
  }

  private static String getNameWithValue(String value) {
    CaseUserTypeEnum[] values = values();
    for (CaseUserTypeEnum caseUserTypeEnum : values) {
      if (caseUserTypeEnum.name().equals(value)) {
        return caseUserTypeEnum.getName();
      }
    }
    return "";
  }

  public static boolean isMediator(String caseUserType) {
    return MEDIATOR.name().equalsIgnoreCase(caseUserType) || MEDIATOR_HELP.name().equalsIgnoreCase(caseUserType)
        || MEDIATOR_HELP_TEMPORARY.name().equalsIgnoreCase(caseUserType);
  }

  public static List<CaseUserTypeEnum> getMediator() {
    return Lists.newArrayList(MEDIATOR, MEDIATOR_HELP, MEDIATOR_HELP_TEMPORARY);
  }
}
