package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.referee.dto.ArbitrationListRequestDTO;
import com.beiming.odr.referee.dto.LitigationCaseProgress;
import com.beiming.odr.referee.dto.requestdto.ArbitrationCaseRequestDTO;
import com.beiming.odr.referee.dto.responsedto.ArbitrationResponseDTO;
import com.beiming.odr.referee.dto.responsedto.AyDictDTO;
import java.util.ArrayList;
import javax.validation.Valid;

@Valid
public interface ArbitrationCaseApi {

  DubboResult<PageInfo<ArbitrationResponseDTO>> getArbitrationListPage(ArbitrationListRequestDTO requestDTO);

  DubboResult<ArrayList<LitigationCaseProgress>> getArbitrationProgress(ArbitrationCaseRequestDTO reqDTO);

  DubboResult<ArbitrationResponseDTO> getArbitrationInfo(ArbitrationCaseRequestDTO reqDTO);

  DubboResult<ArrayList<AyDictDTO>> getAy();
}
