package com.beiming.odr.referee.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.referee.dto.CaseAgentTdhDTO;
import com.beiming.odr.referee.dto.CaseUserTdhDTO;
import com.beiming.odr.referee.dto.requestdto.GDEvidenceReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.JudgeOrMediationOrWithdrawOrSycnDubboReqDTO;
import com.beiming.odr.referee.dto.requestdto.sendtdh.SycnCaseDubboReqDTO;
import javax.validation.Valid;

/**
 * Created by Jache on 2019/01/17 19:55.
 */
@Valid
public interface ThirdPartyPushApi {

  /**
   * @Description: 申请司法确认
   * @Param: DubboResult
   * @return: void
   * @Author: JACHE
   * @Date: 2019/1/18 0018
   */
  DubboResult applyJudgeConfirmation(JudgeOrMediationOrWithdrawOrSycnDubboReqDTO dubboReqDTO);

  /**
   * @Description: 申请调解书
   * @Param: [caseId]
   * @return: void
   * @Author: JACHE
   * @Date: 2019-01-19
   */
  DubboResult applyMediationBook(JudgeOrMediationOrWithdrawOrSycnDubboReqDTO dubboReqDTO);

  /**
   * @Description: 当事人撤回调解
   * @Param: [caseId]
   * @return: void
   * @Author: JACHE
   * @Date: 2019-01-19
   */
  DubboResult withdrawMediation(JudgeOrMediationOrWithdrawOrSycnDubboReqDTO dubboReqDTO);

  String syncCaseUser(@Valid CaseUserTdhDTO data, String citeCaseId);

  String  syncCaseAgent(CaseAgentTdhDTO caseAgentTdhDTO, String citeCaseId);

  DubboResult gdEvidenceDownload(GDEvidenceReqDTO gdEvidenceReqDTO);

  DubboResult syncMediationSuccessOrFailStatus(@Valid SycnCaseDubboReqDTO dubboReqDTO);
}
