package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.enums.RegisterOriginEnum;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;


/**
 * @Description: 案件相关人
 * @Author: caiwei
 * @Date: Created 2018-06-25
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@EncryptDecryptData
public class MediationCasePersonnelDTO implements Serializable {

  private static final long serialVersionUID = 5946545033240232723L;

  /**
   * id
   */
  private Long id;

  /**
   * 案件号
   */
  @EncryptDecryptField
  private String caseNum;

  /**
   * 案件id
   */
  private Long lawCaseId;

  /**
   * 案件文书id
   */
  private Long documentId;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String caseUserType;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String name;

  /**
   * 性别
   */
  private String sex;

  /**
   * 联系电话
   */
  @EncryptDecryptField
  private String phone;

  /**
   * 身份证号
   */
  @EncryptDecryptField
  private String idCard;
  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 详细地址
   */
  @EncryptDecryptField
  private String address;

  /**
   * 信用代码
   */
  @EncryptDecryptField
  private String creditCode;

  /**
   * 法人代表
   */
  private String corporation;

  /**
   * 排序
   */
  private Integer userOrder;

  /**
   * 固话
   */
  @EncryptDecryptField
  private String telephone;

  /**
   * 信访代理人委托书主键id
   */
  private String proxyId;

  /**
   * 信访代理人委托书id
   */
  private String proxyFileId;

  /**
   * 信访代理人委托书名称
   */
  private String proxyFileName;

  /**
   * 电子邮箱
   */
  private String email;

  /**
   * 用户注册来源(0: 用户自己注册  1: 平台自动注册)
   */
  private RegisterOriginEnum userRegisterOrigin;
  /**
   * 審批狀態
   */
  private String approvalStatus;

  @EncryptDecryptField
  private List<MediationCaseAgentPersonnelDTO> agentList;

  //国籍
  private String nationality;
  //民族
  private String nation;

  /** 国籍中文名称 */
  private String nationalityName;
  /** 民族中文名称 */
  private String nationName;
  /** 证件类型中文名称 */
  private String cardTypeName;
  private String citePartyId; //通达海当事人序号

  // 是否待审批：true=待审批，false=无需审批
  private Boolean isApprovalWaiting;

  private Long auditId; //审批表id

  // 最新修改
  private MediationCasePersonnelBriefDTO latestModify;

  private Boolean repairFlag; //是否可失联修复标识

  private List<String> sparePhone; //备用号码
  public MediationCasePersonnelDTO(Long userId, String caseUserType, String name, String sex,
      String phone, String idCard, String address, String creditCode, String agentName,
      String agentSex, String agentPhone, String agentIdCard, Integer order) {
    super();
    this.userId = userId;
    this.caseUserType = caseUserType;
    this.name = name;
    this.sex = sex;
    this.phone = phone;
    this.idCard = idCard;
    this.address = address;
    this.creditCode = creditCode;
    this.userOrder = order;

  }

}
