package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.annotation.EncryptDecryptField;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import lombok.Data;

@Data
public class LawCaseSubsidyReqDTO implements Serializable {

  /**
   * 案件ID
   */
  private Long lawCaseId;

  /**
   * 案件编号
   */
  @EncryptDecryptField
  private String caseNo;


  /**
   * 金额
   */
  private BigDecimal amount;

  /**
   * 到账状态 0未到账 1已到账
   */
  private Integer confirmStatus;

  /**
   * 案件标签
   */
  private String caseTag;

  /**
   * 创建人ID
   */
  private Long createId;

  /**
   * 创建人
   */
  private String createUser;
  /**
   * 文件信息
   */
  @NotEmpty(message = "文件不能为空")
  private List<LawCaseSubsidyFileDTO> files;


  /**
   * 备注
   */
  private String remark;
}
