package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.beiming.odr.referee.enums.ResolutionTypeEnum;
import com.beiming.odr.referee.enums.UserRoleEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.Data;
import org.springframework.beans.factory.annotation.Value;

/**
 * @Description: 录入案件请求参数实体类
 * @Author: caiwei
 * @Date: Created 2018-06-27
 */
@Data
@EncryptDecryptData
public class MediationCaseReqDTO implements Serializable {

  private static final long serialVersionUID = -6625063532079830540L;

  /**
   * 调解类型（人民调解，行政调解）
   */
  private String mediationType;

  /**
   * 案件录入人id
   */
  private Long creatorId;

  /**
   * 案件录入人的身份
   */
  private UserRoleEnum creatorType;

  /**
   * 案件编号
   */
  @EncryptDecryptField
  private String caseNo;

  /**
   * 状态码(05纠纷被拒绝受理等)
   */
  private String lawCaseStatus;

  /**
   * 审批类型：1=延期；2=纠纷信息
   */
  private Integer approvalType;

  /**
   * 案件进度
   */
  private String caseProgress;

  /**
   * 咨询纠纷id，咨询转立案存入该值
   */
  private Long disputesId;

  /**
   * 纠纷类型字典表code
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型
   */
  private String disputeType;

  /**
   * 省份code
   */
  private String provCode;

  /**
   * 城市code
   */
  private String cityCode;

  /**
   * 区code
   */
  private String areaCode;

  /**
   * 街道code
   */
  private String streetCode;

  /**
   * 社区code
   */
  private String communityCode;

  /**
   * 省份名称
   */
  private String provName;

  /**
   * 城市名称
   */
  private String cityName;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 详细地址
   */
  @EncryptDecryptField
  private String address;

  /**
   * 机构id
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 机构地区code
   */
  private String orgAreaCode;

  /**
   * 调解员id
   */
  private Long mediatorId;

  /**
   * 调解员名称
   */
  private String mediatorName;

  /**
   * 案件来源。本平台录入； 第三方平台导入。网上立案系统导入，律师平台导入
   */
  private String origin;

  /**
   * 选择性短信发送功能 0为发送，1为不发送
   */
  private Boolean smsOff;

  /**
   * 申请人诉求
   */
  private String appeal;

  /**
   * 纠纷描述
   */
  private String disputeContent;

  // 案件人
  @NotNull(message = "{case.person.cannot.be.empty}")
  private List<MediationCaseUserReqDTO> personnelList;

  // 创建者
  private String createUser;

  // 更新者
  private String updateUser;

  /**
   * 信访代理人
   */
  private PetitionAgentReqDTO petitionAgentReqDTO;

  private String citeCaseId;

  private String citeCaseName;

  private List<EvidenceRequestDTO> evidenceList;

  private Integer caseType;

  private String disputeAmount;

  @Value("0")
  private int isSuspend;

  @Value("0")
  private int suspendNum;

  /**
   * 调解开始时间
   */
  private Date startTime;

  /**
   * 调解结束时间
   */
  private Date endTime;

  /** 关联平台（POLICE_STATION：(公安)驻所） */
  private String thirdPlatform;

  /** 关联平台的机构id */
  private String thirdId;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 是否简易案件 1是0否
   */
  private Integer simple;
  /**
   * 客户端类型
   */
  private String clientType;

  /**
   * 国家
   */
  private String country;

  /**
   * 国家代码
   */
  private String countryCode;

  /**
   * 案件类型(mediate:调解；arbitration:仲裁；litigation:诉讼)
   */
  private ResolutionTypeEnum resolutionType;

  /**
   * 第三方服务选项
   */
  private String thirdPartyServicesStr;
}
