package com.beiming.odr.referee.dto.requestdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.NotNull;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author zhouxin
 * @since 2019/8/6
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(description = "金融类案件审核请求参数")
public class ReviewPassRequestDTO {

  @ApiModelProperty(value = "案件ID集合", position = 0)
  @NotNull(message = "{case.id.cannot.be.empty}")
  private List<Long> lawCaseIds;

  @ApiModelProperty(value = "是否全部审批")
  private Boolean isAll = false;
}
