package com.beiming.odr.referee.dto.requestdto.haoda;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 司法确认申请请求DTO
 *
 * @author xiaoying
 * @date 2021/11/25
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ApplyJudicialConfirmRequestDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  @ApiModelProperty(notes = "申请案件id", example = "666")
  private String applyCaseId;

  @ApiModelProperty(notes = "分级码", example = "JB1")
  private String levelCode;

  /**
   * 1本人申请 2 律师申请 9 其他代理人申请
   */
  @ApiModelProperty(notes = "申请人类型", example = "普通用户/律师")
  private String applyUserType;

  @ApiModelProperty(notes = "申请人姓名", example = "张三")
  private String applyUserName;

  @ApiModelProperty(notes = "申请人手机号码", example = "13888888888")
  private String applyUserPhone;

  @ApiModelProperty(notes = "申请人性别", example = "1 男 2 女")
  private Integer applyUserSex;

  @ApiModelProperty(notes = "申请金额", example = "666")
  private String applyMoney;

  @ApiModelProperty(notes = "标的物", example = "纠纷物品")
  private String disputeGoods;

  @ApiModelProperty(notes = "标的行为", example = "纠纷行为")
  private String disputeBehavior;

  @ApiModelProperty(notes = "申请时间", example = "2020-11-02 11:00:00")
  private String applyTime;

  @ApiModelProperty(notes = "调解员姓名", example = "李四")
  private String mediatorName;

  @ApiModelProperty(notes = "调解员证件号码", example = "532926199603121718")
  private String mediatorIdCard;

  @ApiModelProperty(notes = "最高院案由代码", example = "2323")
  private String caseReason;

  /**
   * 1涉外 2 涉港 3 涉澳 4 涉台 5 涉侨 255 无涉及
   */
  @ApiModelProperty(notes = "案件涉及类型", example = "1")
  private String caseType;

  @ApiModelProperty(notes = "诉讼请求", example = "1")
  private String appeal;

  @ApiModelProperty(notes = "事实与理由", example = "1")
  private String reason;

  /**
   * 调解机构类型 1 人民调解委员会 2 特邀调解组织 3.特邀调解员
   */
  @ApiModelProperty(notes = "调解机构类型", example = "1")
  private String organizationType;

  @ApiModelProperty(notes = "调解机构名称", example = "1")
  private String organizationName;

  @ApiModelProperty(notes = "案件编号", example = "1")
  private String caseNo;

  @ApiModelProperty(notes = "当事人列表", example = "1")
  private List<ApplyParty> applyPartyList;

  @ApiModelProperty(notes = "平台申请文书材料列表", example = "1")
  private List<ApplyDocument> applyDocumentList;

  @ApiModelProperty(notes = "司法确认申请文书材料列表", example = "1")
  private List<ApplyDocument> judicialDocumentList;

  @ApiModelProperty(notes = "申请视频材料列表", example = "1")
  private List<ApplyVideo> applyVideoList;

  /**
   * 是否涉及疫情
   */
  private Integer isEpidemicSituation;

  /**
   * 是否财产保全
   */
  private Integer isPropertyPreservation;
}