package com.beiming.odr.referee.dto.responsedto;

import com.beiming.framework.util.Date2LongSerialize;
import com.beiming.odr.referee.annotation.EncryptDecryptData;
import com.beiming.odr.referee.annotation.EncryptDecryptField;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 卷宗返回列表实体类
 *
 * @author qsh
 * @data 2018年6月29日
 */
@Data
@EncryptDecryptData
public class DossierAttchmentListResDTO implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long id;
  private String createUser; // 立卷人
  private String applicantNames; // 申请人姓名
  private String disputeType; // 纠纷类型
  @EncryptDecryptField
  private String caseNo; // 案件编号
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date caseCreateTime; // 登记日期
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date caseCompleteTime; // 结案日期
  private Long auditorId; // 审核人ID
  private String auditorName; // 审核人姓
  private Long lawCaseId; // 案件ID
  private String checkStatus; // 审核状态
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime;
  private String disputeTypeCode; // 纠纷类型字典表code

}
