/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.referee.enums;

public enum ExamineStatusEnum {
    UNREVIEWED(0, "\u672a\u5ba1\u6838"),
    REVIEW_PASS(1, "\u5ba1\u6838\u901a\u8fc7"),
    REVIEW_NO_PASS(2, "\u5ba1\u6838\u4e0d\u901a\u8fc7");

    private final Integer index;
    private final String desc;

    private ExamineStatusEnum(int index, String desc) {
        this.index = index;
        this.desc = desc;
    }

    public static Boolean isExamine(Integer examineResult) {
        return REVIEW_PASS.getIndex() == examineResult.intValue() || REVIEW_NO_PASS.getIndex() == examineResult.intValue();
    }

    public int getIndex() {
        return this.index;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ExamineStatusEnum findByIndex(Integer index) {
        if (index == null) {
            return UNREVIEWED;
        }
        for (ExamineStatusEnum en : ExamineStatusEnum.values()) {
            if (!index.equals(en.getIndex())) continue;
            return en;
        }
        return UNREVIEWED;
    }
}

