package com.beiming.odr.referee.context;


import com.beiming.odr.referee.dto.responsedto.ThirdPartyConfigResDTO;

/**
 * 当前线程第三方app
 * @author JACHE
 */
public class ThirdpartyAppContextHolder {
  private static final ThreadLocal<ThirdPartyConfigResDTO> CONTEXT_HOLDER = new ThreadLocal<>();

  /**
   * 设置appName
   */
  public static void setApp(ThirdPartyConfigResDTO app) {
    CONTEXT_HOLDER.set(app);
  }

  /**
   * 获取appName
   * @return
   */
  public static ThirdPartyConfigResDTO getApp() {
    return CONTEXT_HOLDER.get();
  }

 
}
