package com.beiming.odr.referee.dto;

import com.beiming.odr.referee.annotation.EncryptDecryptData;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ProjectName: hainan-guoshang
 * @Package: com.beiming.odr.referee.dto
 * @ClassName: EdsrInfoDTO
 * @Author: lanqingyun
 * @Description:
 * @Date: 2024/5/14 15:23
 * @Version: 1.0
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@EncryptDecryptData
public class EdsrInfoDTO  implements Serializable {

  /**
   * id
   */
  private Long id;

  /**
   * 案件id
   */
  private Long ahdm;

  /**
   * 案件用户类型（0：申请人 1：被申请人）
   */
  private String ssdw;

  /**
   * 用户类型（0：自然人 1：法人 2：非法人组织）
   */
  private String userType;

  /**
   * 名称(类别为法人/非法人组织时, 填单位名称)
   */
  private String name;

  /**
   * 性别
   */
  private String sex;

  private String xbCode;

  /**zzjgdm;
   * 联系电话
   */
  private String phone;

  /**
   * 身份证号
   */
  private String idCard;
  /**
   * 证件类型
   */
  private String cardType;

  /**
   * 证件类型代码
   */
  private String cardTypeCode;
  /**
   * 组织机构代码
   */
  private String zzjgdm;


  /**
   * 详细地址
   */
  private String address;

  /**
   * 信用代码
   */
//  private String creditCode;

  /**
   * 电子邮箱
   */
  private String email;


  //国籍
  private String nationality;

  private String gjCode;
  //民族
  private String nation;

  private String mzCode;

  private String lang;

  @ApiModelProperty(value = "人员类型")
  private String lx;

  @ApiModelProperty(value = "其他身份证件种类")
  private String qtzjzl;

  @ApiModelProperty(value = "其他身份证件号码")
  private String qtzjhm;

}
