package com.beiming.odr.referee.dto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: chenjt
 * @Description: 平台地图统计
 * @Date: Created 2018-11-09 12:37
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PlatMapStatisticsDTO implements Serializable {


  private static final long serialVersionUID = 4333352870902007238L;
  /**
   * 区域编码
   */
  private String areaCode;

  /**
   * 调解案件量
   */
  private Integer lawCaseCount;
  /**
   * 调解机构数量(不用查,用户口接口提供)
   */
  private Integer orgCount;
  /**
   * 调解案件成功数量
   */
  private Integer caseSuccessCount;

  /**
   * 调解案件失败数量
   */
  private Integer caseFailCount;

  /**
   * 诉讼案件数量
   */
  private Integer suitCount;

  /**
   * 司法确认案件数量
   */
  private Integer judicialCount;

}
