package com.beiming.odr.referee.dto.requestdto;

import com.beiming.odr.referee.dto.AreaCodeDTO;
import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @Author: chenjt
 * @Description: 平台地图
 * @Date: Created 2018-11-09 10:02
 */
@Data
public class DisputePlatMapStatisticsReqDTO implements Serializable {


  /**
   * 纠纷发生区域
   */
  private List<String> areaCodes;

  /**
   * 纠纷发生区域(带level)
   */
  private List<AreaCodeDTO> areaCodeList;

  /**
   * 开始时间
   */
  private String startDate;

  /**
   * 结束时间
   */
  private String endDate;

  /**
   * 查询条件(调用者不传)
   */
  private String areaCode;
  /**
   * 禁用的机构
   */
  private List<Long> disableOrgIds;

  /**
   * 当前系统登录用户的组织机构id
   */
  private String currentOrgIds;

  /**
   * dbLink跨库查询
   */
  private String dbLinkAddress;

}
