package com.beiming.odr.referee.dto.requestdto;

import com.beiming.framework.domain.BaseObject;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;


/**
 * @author summer
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class MediationExtendRegionalConfirmReqDTO extends BaseObject implements Serializable {
  private static final long serialVersionUID = 4521652881528725696L;

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 申请表id
   */
  @NotNull(message = "申请ID不能为空")
  private Long extendId;

  /**
   * 申请类型， 延期申请 - DELAY、办结申请 - DONE、重新分派申请 - ASSIGN
   */
  @NotEmpty(message = "申请类型不能为空")
  @Pattern(regexp = "^(DELAY|DONE|ASSIGN)$", message = "申请类型不合法")
  private String extendType;

  /**
   * 案件id
   */
  @NotNull(message = "案件ID不能为空")
  private Long lawCaseId;

  /**
   * 确认状态
   */
  private String confirmStatus;

  /**
   * 是否同意：true=同意|false=不同意
   */
  @NotNull(message = "是否同意为空")
  private Boolean isAgree;

  /**
   * 审批意见
   */
  @Size(max = 500, message = "审核意见长度不能超过500")
  private String confirmComments;

}
