package com.beiming.odr.referee.dto.requestdto.calc;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Data;

@Data
public class CalcGetDataReqDTO  implements Serializable {

  private static final long serialVersionUID = 4012167287636968378L;
  private  Integer status;
  @NotNull(
      message = "当前页码不能为空。"
  )
  @Min(
      value = 1L,
      message = "当前页码必须大于0。"
  )
  private Integer pageNum;
  @NotNull(
      message = "每页的数量不能为空。"
  )
  @Min(
      value = 8L,
      message = "每页的数量必须大于0。"
  )
  private Integer pageSize;
}
