package com.beiming.odr.referee.dto.responsedto;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Description 视频会议基础数据项
 * @Author blake
 * @Date 2020/3/11 5:34 下午
 * @Version 1.0
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MeetingInfoResDTO implements Serializable {

  private static final long serialVersionUID = -3980501328090013532L;

  @ApiModelProperty(value = "案件id", position = 0)
  private Long lawCaseId;

  @ApiModelProperty(value = "会议类型", position = 1)
  private String meetingType;

  @ApiModelProperty(value = "视频会议状态", position = 2)
  private String meetingStatus;

  @ApiModelProperty(value = "视频会议预约时间", position = 3)
  private Date orderTime;

}
