package com.beiming.odr.referee.dto.responsedto.haoda;

import java.io.Serializable;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 网上立案和司法确认案件详情 响应DTO
 * @author xiaoying
 * @date 2022/01/17
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CaseDetailResDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 案件id
   */
  private Long caseId;

  /**
   * 类型 1网上立案 2司法确认
   */
  private Integer type;

  /**
   * 案号
   */
  private String caseNumber;

  /**
   * 受理法院
   */
  private String courtName;

  /**
   * 案件类型
   */
  private String caseTypeName;

  /**
   * 民事案由
   */
  private String caseAppeal;

  /**
   * 纠纷金额
   */
  private String caseMoney;

  /**
   * 纠纷物品
   */
  private String disputeGoods;

  /**
   * 纠纷行为
   */
  private String disputeBehavior;

  /**
   * 提交时间
   */
  private String submitTime;

  /**
   * 入库时间
   */
  private String enterTime;

  /**
   * 入库结果
   */
  private String enterResult;

  /**
   * 审核时间
   */
  private String checkTime;

  /**
   * 审核结果
   */
  private String checkResult;

  /**
   * 审核意见
   */
  private String checkContent;

  /**
   * 请求内容
   */
  private String appeal;

  /**
   * 申请人信息
   */
  private List<CaseUserDetailDTO> applicantList;

  /**
   * 被申请人信息
   */
  private List<CaseUserDetailDTO> respondentList;

  /**
   * 证据材料
   */
  private List<CaseDocumentDetailDTO> documentList;

  /**
   * 司法确认文书材料
   */
  private List<DocumentListResDTO> judicialDocumentList;

  private Integer applyUserType;

  /**
   * 是否涉及疫情
   */
  private Integer isEpidemicSituation;

  /**
   * 是否财产保全
   */
  private Integer isPropertyPreservation;

  /**
   * 莞邑案件状态
   * ASSIGN 待分配
   * AUDIT 待审核
   * AUDITED 已审核
   */
  private String caseStatus;

  /**
   * 莞邑案件审核结果
   *  WAIT 等待审核
   *  SUCCESS 审核成功
   *  FAIL 审核失败
   */
  private String caseAudit;

  /**
   * 审核时间
   */
  private String auditTime;

  /**
   * 审核意见
   */
  private String auditIdea;

  /**
   * 分配时间
   */
  private String assignTime;

  /**
   * 案件进度历史
   */
  private List<CaseProgressDTO> progressList;

  /**
   * law_case_check表主键
   */
  private Long lawCaseCheckId;
}