package com.beiming.odr.referee.dto.responsedto.haoda;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author xiaoying
 * @date 2022/03/04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LawCaseCheckDTO implements Serializable {

  private static final long serialVersionUID = -3209068441805383190L;

  private Long id;

  /**
   * 案件Id
   */
  private Long lawCaseId;

  /**
   * 法院编码
   */
  private String courtCode;

  /**
   * 法院名称
   */
  private String courtName;

  /**
   * 申请人类型
   */
  private Integer applyUserType;

  /**
   * 类型id
   */
  private Long caseTypeId;


  /**
   * 类型名称
   */
  private String caseTypeName;

  /**
   * 是否涉及疫情
   */
  private Integer isEpidemicSituation;

  /**
   * 是否财产保全
   */
  private Integer isPropertyPreservation;

  /**
   * 纠纷金额
   */
  private String disputeMoney;

  /**
   * 纠纷物品
   */
  private String disputeGoods;

  /**
   * 纠纷行为
   */
  private String disputeBehavior;

  /**
   * 案由编码
   */
  private String disputeCodeId;

  /**
   * 案由名称
   */
  private String disputeCodeName;

  /**
   * 诉求
   */
  private String disputeAppeal;

  /**
   * 事实与理由
   */
  private String reason;

  /**
   * 备注
   */
  private String remark;

  /**
   * 状态 1 正常 0 删除
   */
  private Integer status;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 1等待审核 2审核通过 3审核失败
   */
  private Integer checkState;

  /**
   * 审核用户Id
   */
  private Long checkUserId;

  /**
   * 审核用户姓名
   */
  private String checkUserName;

  /**
   * 分配时间
   */
  private Date assignTime;

  /**
   * 审核时间
   */
  private Date checkTime;

  /**
   * 数据状态 0 草稿 1正常 2作废
   */
  private Integer draft;

  /**
   * 审核内容
   */
  private String checkContent;

}