package com.beiming.odr.referee.dto;

import java.io.Serializable;
import java.util.List;
import lombok.Data;

/**
 * @author jiangfan
 * @date 2025/09/01
 */
@Data
public class TurnArbitrationEvidenceDTO implements Serializable {

  /**
   * 法院证据材料唯一标识(ID)
   */
  private Long id;

  /**
   * 仲裁证据材料唯一标识(ID)（和法院id一一对应）
   */
  private Integer arbitrateId;

  /**
   * 证据名称
   */
  private String name;

  /**
   * 见字典：证据来源
   */
  private String resource;

  /**
   * 证据数量
   */
  private Integer count;

  /**
   * 证据目的
   */
  private String purpose;

  private List<TurnArbitrationAttamentsDTO> attaments;

}
