package com.beiming.odr.referee.dto.requestdto.haoda;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 昊达司法确认结果
 * @author xiaoying
 * @date 2021/12/24
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class JudicialConfirmResultDTO implements Serializable {

  private static final long serialVersionUID = -7719004967037558229L;

  /**
   * 案件Id
   */
  private String caseId;

  /**
   * 用户Id
   */
  private String userId;

  /**
   * 司法确认或网上立案结果 1成功 2失败
   */
  private String result;

  /**
   * 失败时备注原因
   */
  private String remark;

  /**
   * 是司法确认还是网上立案
   * 1 网上立案 2 司法确认
   */
  private String type;

  /**
   * 昊达案件查询号
   */
  private String queryNo;
}