package com.beiming.odr.referee.dto.responsedto;

import com.beiming.framework.util.Date2LongSerialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import lombok.Data;

/**
 * 分装卷宗回显
 * 
 * @author qsh
 * @data 2018年7月5日
 */
@Data
public class DisplayDossierResDTO implements Serializable {
  private static final long serialVersionUID = 1L;
  private Long creatorId; // 立卷人ID
  private Long orgId; // 所属机构ID
  private String orgName; // 所属机构名称
  private String applicantNames; // 申请人姓名
  private String disputeType; // 纠纷类型
  private String lawCaseDossierName; // 卷宗名称(申请人+纠纷类型)
  private String caseNo; // 案件编号
  private Long mediatorId; // 调解员ID
  private String agreementYear; // 协议编号 (年)
  private String mediatorsName; // 调解员姓名
  private String agreementNumber; // 协议编号(号)
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date caseCreateTime; // 登记日期
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date caseCompleteTime; // 结案日期
  private Integer storagePeriod; // 保管期限
  private Long auditorId; // 审核人ID
  private String auditorName; // 审核人姓
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date auditorTime; // 审核时间
  private Long lawCaseId; // 案件编号
  private String checkStatus; // 审核状态
  private String createUser; // 立卷人姓名
  @JsonSerialize(using = Date2LongSerialize.class)
  private Date createTime; // 立卷时间
  private String remark; // 备注
  private String volumeSign; // 卷宗目录
  private String volumeName; // 卷宗目录
  private String backCoverSign; // 封底
  private String backCoverSignName; // 封底
  private ArrayList<DossierAttachmentResDTO> dossierAttachmentResDTO;
}
